/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog;

import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.app.comp.BorderJPanel;
import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.app.comp.EditableNumericSpinner;
import DE.siemens.ad.logo.comm.DataTransfer;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.block.AnalogInputBlock;
import DE.siemens.ad.logo.model.block.AnalogMarkerBlock;
import DE.siemens.ad.logo.model.block.AnalogOutputBlock;
import DE.siemens.ad.logo.model.block.InputBlock;
import DE.siemens.ad.logo.model.block.KeyInputBlock;
import DE.siemens.ad.logo.model.block.MarkerBlock;
import DE.siemens.ad.logo.model.block.OutputBlock;
import DE.siemens.ad.logo.model.block.ShiftRegisterInputBlock;
import DE.siemens.ad.logo.model.block.TDFunctionKeyInputBlock;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoProperties;
import DE.siemens.ad.logo.util.ProgramException;
import DE.siemens.ad.logo.util.Util;
import DE.siemens.ad.pdraw.simulation.ProcessImageParser;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class IOStatusPanel
extends DataInputPanel {
    private BorderJPanel fExportPanel;
    private BorderJPanel fPropertiesPanel;
    private BorderJPanel fShowFunctionPanel;
    private JCheckBox fShowTimeLine;
    private JCheckBox fShowI;
    private JCheckBox fShowQ;
    private JCheckBox fShowM;
    private JCheckBox fShowAI;
    private JCheckBox fShowAQ;
    private JCheckBox fShowAM;
    private JCheckBox fShowCC;
    private JCheckBox fShowFC;
    private JCheckBox fShowSR;
    private EditableNumericSpinner fMaxCount;
    private EditableNumericSpinner fCycleTime;
    private JButton fExportButton;
    private JButton fRemoveButton;
    private Timer fTickerTimer;
    private IODataModel fModel;
    private TextArea fFileName;
    private JTable fTable;
    private JScrollPane fTablePanel;
    private DataTransfer fDataTransfer;
    private IOStatusProcessImageParser fValueParser;
    private FileOutputStream fFileStream;
    private OutputStreamWriter fFileWriter;
    private static final int TL = -1;
    private static final int TIME_LINE_LENGTH = 80;

    public IOStatusPanel(DataTransfer dt) {
        this.fDataTransfer = dt;
        this.initialize();
    }

    private IOStatusPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setName(Language.getString("extra.transfer.IOStatus.overview", "I/O Status Overview"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = new Insets(3, 3, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        this.fTablePanel = new JScrollPane(this.getRecordsTable());
        this.fTablePanel.setPreferredSize(new Dimension(747, 360));
        this.add((Component)this.fTablePanel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridheight = 2;
        gbc.gridwidth = 1;
        this.add((Component)this.getShowFunctionPanel(), gbc);
        gbc.insets = new Insets(3, 3, 0, 3);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridheight = 1;
        this.add((Component)this.getPropertiesPanel(), gbc);
        gbc.insets = new Insets(0, 3, 0, 3);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridheight = 1;
        this.add((Component)this.getExportPanel(), gbc);
    }

    private JPanel getExportPanel() {
        if (this.fExportPanel == null) {
            this.fExportPanel = new BorderJPanel();
            this.fExportPanel.setLayout(new GridBagLayout());
            this.fExportPanel.setTitle(Language.getString("extra.transfer.IOStatus.logFile", "Log File"));
            this.fExportButton = new JButton();
            this.fExportButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    File file = Application.getInstance().chooseCSVFile(IOStatusPanel.this, "LogFile", 1);
                    if (file != null) {
                        if (IOStatusPanel.this.fFileName.getText().equalsIgnoreCase(file.getAbsolutePath())) {
                            return;
                        }
                        IOStatusPanel.this.closeFile();
                        IOStatusPanel.this.fFileName.setText(file.getAbsolutePath());
                        IOStatusPanel.this.prepareLogFile(file.getAbsolutePath());
                    }
                }
            });
            this.fExportButton.setText(Language.getString("dialog.IOStatus.ChangeLogFile", "Change Log File"));
            this.fFileName = new TextArea(Language.getString("dialog.IOStatus.EmptyLogFile", "No assigned log file."), 2, 50, 1);
            this.fFileName.setEditable(false);
            this.fRemoveButton = new JButton();
            this.fRemoveButton.setText(Language.getString("dialog.options.connectionTab.removeButtonText", "Remove"));
            this.fRemoveButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    IOStatusPanel.this.fFileName.setText(Language.getString("dialog.IOStatus.EmptyLogFile", "No assigned log file."));
                    IOStatusPanel.this.closeFile();
                }
            });
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.gridx = 0;
            gbc.gridy = 0;
            this.fExportPanel.add((Component)this.fExportButton, gbc);
            gbc.fill = 1;
            gbc.weightx = 1.0;
            gbc.gridx = 1;
            gbc.gridy = 0;
            this.fExportPanel.add((Component)new JPanel(), gbc);
            gbc.fill = 0;
            gbc.weightx = 0.0;
            gbc.gridx = 2;
            gbc.gridy = 0;
            this.fExportPanel.add((Component)this.fRemoveButton, gbc);
            gbc.fill = 1;
            gbc.gridwidth = 3;
            gbc.gridx = 0;
            gbc.gridy = 1;
            this.fExportPanel.add((Component)this.fFileName, gbc);
        }
        return this.fExportPanel;
    }

    private BorderJPanel getPropertiesPanel() {
        if (this.fPropertiesPanel == null) {
            this.fPropertiesPanel = new BorderJPanel();
            this.fPropertiesPanel.setTitle(Language.getString("dialog.options.printingTab.borderPanel.properties", "Properties"));
            this.fPropertiesPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            this.fMaxCount = new EditableNumericSpinner();
            this.fMaxCount.setName("fMaxCount");
            this.fMaxCount.setMinMax(20, 100);
            this.fMaxCount.setIncrement(5);
            this.fMaxCount.setEnableInput(false);
            JLabel fMaxCountLabel = new JLabel();
            fMaxCountLabel.setText(Language.getString("dialog.IOStatus.MaxCount", "Set max count:"));
            JPanel countPanel = new JPanel(new FlowLayout(0));
            countPanel.add(fMaxCountLabel);
            countPanel.add(this.fMaxCount);
            gbc.fill = 2;
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.weightx = 40.0;
            gbc.weighty = 0.0;
            this.fPropertiesPanel.add((Component)countPanel, gbc);
            this.fCycleTime = new EditableNumericSpinner();
            this.fCycleTime.setName("fCycleTime");
            this.fCycleTime.setMinMax(500, 30000);
            this.fCycleTime.setIncrement(500);
            this.fCycleTime.setEnableInput(false);
            JLabel fCycleTimeLabel = new JLabel();
            fCycleTimeLabel.setText(Language.getString("dialog.IOStatus.CycleTime", "Set cycle time:"));
            JLabel lTimeUnit = new JLabel(Language.getString("dialog.parameter.message.menu.tickerTimeUnit", "ms"));
            JPanel cyclePanel = new JPanel(new FlowLayout(0));
            cyclePanel.add(fCycleTimeLabel);
            cyclePanel.add(this.fCycleTime);
            cyclePanel.add(lTimeUnit);
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.weighty = 0.0;
            this.fPropertiesPanel.add((Component)cyclePanel, gbc);
        }
        return this.fPropertiesPanel;
    }

    private BorderJPanel getShowFunctionPanel() {
        if (this.fShowFunctionPanel == null) {
            this.fShowFunctionPanel = new BorderJPanel();
            this.fShowFunctionPanel.setTitle(Language.getString("dialog.IOStatus.ShowProperties", "Show"));
            this.fShowFunctionPanel.setLayout(new GridBagLayout());
            this.fShowTimeLine = new JCheckBox(Language.getString("dialog.IOStatus.ShowTimeLine", "Time"));
            this.fShowTimeLine.setSelected(true);
            this.fShowTimeLine.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    IOStatusPanel.this.showHideProperty(-1, IOStatusPanel.this.fShowTimeLine.isSelected());
                }
            });
            this.fShowI = new JCheckBox(Language.getString("dialog.IOStatus.Show.Inputs", "Inputs"));
            this.fShowI.setSelected(true);
            this.fShowI.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    IOStatusPanel.this.showHideProperty(6, IOStatusPanel.this.fShowI.isSelected());
                }
            });
            this.fShowQ = new JCheckBox(Language.getString("dialog.IOStatus.Show.Outputs", "Outputs"));
            this.fShowQ.setSelected(true);
            this.fShowQ.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    IOStatusPanel.this.showHideProperty(7, IOStatusPanel.this.fShowQ.isSelected());
                }
            });
            this.fShowAI = new JCheckBox(Language.getString("dialog.IOStatus.Show.AnalogInputs", "Analog inputs"));
            this.fShowAI.setSelected(true);
            this.fShowAI.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    IOStatusPanel.this.showHideProperty(11, IOStatusPanel.this.fShowAI.isSelected());
                }
            });
            this.fShowAQ = new JCheckBox(Language.getString("dialog.IOStatus.Show.AnalogOutputs", "Analog outputs"));
            this.fShowAQ.setSelected(true);
            this.fShowAQ.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    IOStatusPanel.this.showHideProperty(13, IOStatusPanel.this.fShowAQ.isSelected());
                }
            });
            this.fShowM = new JCheckBox(Language.getString("dialog.IOStatus.Show.Flags", "Flags"));
            this.fShowM.setSelected(true);
            this.fShowM.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    IOStatusPanel.this.showHideProperty(10, IOStatusPanel.this.fShowM.isSelected());
                }
            });
            this.fShowAM = new JCheckBox(Language.getString("dialog.IOStatus.Show.AnalogFlags", "Analog flags"));
            this.fShowAM.setSelected(true);
            this.fShowAM.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    IOStatusPanel.this.showHideProperty(16, IOStatusPanel.this.fShowAM.isSelected());
                }
            });
            this.fShowSR = new JCheckBox(Language.getString("dialog.IOStatus.Show.ShiftRegisterBits", "Shift register bits"));
            this.fShowSR.setSelected(true);
            this.fShowSR.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    IOStatusPanel.this.showHideProperty(19, IOStatusPanel.this.fShowSR.isSelected());
                }
            });
            this.fShowCC = new JCheckBox(Language.getString("dialog.IOStatus.Show.CursorKeys", "Cursor keys"));
            this.fShowCC.setSelected(true);
            this.fShowCC.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    IOStatusPanel.this.showHideProperty(17, IOStatusPanel.this.fShowCC.isSelected());
                }
            });
            this.fShowFC = new JCheckBox(Language.getString("dialog.IOStatus.Show.LOGOTDFunctionKeys", "LOGO! TD Function keys"));
            this.fShowFC.setSelected(true);
            this.fShowFC.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    IOStatusPanel.this.showHideProperty(21, IOStatusPanel.this.fShowFC.isSelected());
                }
            });
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            this.fShowFunctionPanel.add((Component)this.fShowI, gbc);
            gbc.gridx = 1;
            gbc.gridy = 0;
            this.fShowFunctionPanel.add((Component)this.fShowAI, gbc);
            gbc.gridx = 0;
            gbc.gridy = 1;
            this.fShowFunctionPanel.add((Component)this.fShowQ, gbc);
            gbc.gridx = 1;
            gbc.gridy = 1;
            this.fShowFunctionPanel.add((Component)this.fShowAQ, gbc);
            gbc.gridx = 0;
            gbc.gridy = 2;
            this.fShowFunctionPanel.add((Component)this.fShowM, gbc);
            gbc.gridx = 1;
            gbc.gridy = 2;
            this.fShowFunctionPanel.add((Component)this.fShowAM, gbc);
            gbc.gridx = 0;
            gbc.gridy = 3;
            this.fShowFunctionPanel.add((Component)this.fShowSR, gbc);
            gbc.gridx = 1;
            gbc.gridy = 3;
            this.fShowFunctionPanel.add((Component)this.fShowTimeLine, gbc);
            gbc.gridx = 0;
            gbc.gridy = 4;
            this.fShowFunctionPanel.add((Component)this.fShowCC, gbc);
            gbc.gridx = 1;
            gbc.gridy = 4;
            this.fShowFunctionPanel.add((Component)this.fShowFC, gbc);
        }
        return this.fShowFunctionPanel;
    }

    private JTable getRecordsTable() {
        this.fTable = new JTable();
        this.fTable.setAutoResizeMode(0);
        this.fTable.setColumnSelectionAllowed(true);
        return this.fTable;
    }

    public boolean checkChanged() {
        return true;
    }

    public boolean checkFieldContents() {
        return this.fCycleTime.checkValue(true) && this.fMaxCount.checkValue(true);
    }

    private Vector getObservedElementNames(Hardware hw) {
        int i;
        Vector<String> ret = new Vector<String>();
        int[] res = hw.getMaxResources();
        ret.add(Language.getString("dialog.IOStatus.ColumnName.Number", "No."));
        ret.add(Language.getString("dialog.IOStatus.ColumnName.Time", "Time"));
        for (i = 0; i < res[6]; ++i) {
            ret.add("I" + (i + 1));
        }
        for (i = 0; i < res[21]; ++i) {
            ret.add("F" + (i + 1));
        }
        for (i = 0; i < res[7]; ++i) {
            ret.add("Q" + (i + 1));
        }
        for (i = 0; i < res[10]; ++i) {
            ret.add("M" + (i + 1));
        }
        for (i = 0; i < res[19]; ++i) {
            ret.add("S" + (i / 8 + 1) + "." + (i % 8 + 1));
        }
        for (i = 0; i < res[17]; ++i) {
            ret.add("C" + (i + 1));
        }
        for (i = 0; i < res[11]; ++i) {
            ret.add("AI" + (i + 1));
        }
        for (i = 0; i < res[13]; ++i) {
            ret.add("AQ" + (i + 1));
        }
        for (i = 0; i < res[16]; ++i) {
            ret.add("AM" + (i + 1));
        }
        return ret;
    }

    public void loadFieldContents() throws ProgramException {
        block8: {
            try {
                int rw;
                if ((this.fDataTransfer.getDeviceState() & 1) == 0 && (rw = JOptionPane.showConfirmDialog(null, Language.getString("onlineTestControl.changeToRunQuestion", "The device is currently in STOP mode.\nWould you like to change to mode to RUN?"), Language.getString("IOStatus.changeToRun", "Change device to RUN mode"), 0)) == 0) {
                    this.fDataTransfer.sendStateCommand(24);
                }
            }
            catch (Exception e) {
                if (this.fDataTransfer == null) break block8;
                this.fDataTransfer.closePort();
                this.fDataTransfer = null;
            }
        }
        Vector names = this.getObservedElementNames(this.fDataTransfer.getHardware());
        this.fModel = new IODataModel(names);
        this.fTable.setModel(this.fModel);
        for (int i = 0; i < this.fTable.getColumnCount(); ++i) {
            if (i == 1) {
                this.fTable.getColumnModel().getColumn(i).setPreferredWidth(80);
            } else if (this.fModel.getColumnName(i).startsWith("A") || this.fModel.getColumnName(i).startsWith("S")) {
                this.fTable.getColumnModel().getColumn(i).setPreferredWidth(55);
            } else {
                this.fTable.getColumnModel().getColumn(i).setPreferredWidth(35);
            }
            this.fTable.getColumnModel().getColumn(i).setResizable(true);
        }
        String fileName = LogoProperties.instance().getProperty("LogFile", "");
        this.fFileName.setText(fileName);
        this.prepareLogFile(fileName);
        this.fCycleTime.setValue(LogoProperties.instance().getIntProperty("IOStatus.cycleTime", 1000));
        this.fMaxCount.setValue(LogoProperties.instance().getIntProperty("IOStatus.recordCount", 40));
        this.fModel.setRecordCount(this.fMaxCount.getValue());
        this.loadShowHideProperty();
        this.fValueParser = new IOStatusProcessImageParser(this.fDataTransfer.getHardware(), names);
        this.fTickerTimer = new Timer();
        this.fTickerTimer.schedule((TimerTask)new IOStatusTimerTask(), 0L, 500L);
    }

    private void prepareLogFile(String fileName) {
        if (fileName.length() > 0) {
            try {
                File logFile = new File(fileName);
                if (!logFile.exists()) {
                    logFile.createNewFile();
                }
                this.fFileStream = new FileOutputStream(logFile);
                this.fFileWriter = new OutputStreamWriter((OutputStream)this.fFileStream, "UTF-8");
                StringBuffer strBuffer = new StringBuffer(this.fModel.getColumnName(1));
                for (int i = 2; i < this.fModel.getColumnCount(); ++i) {
                    strBuffer.append(',');
                    strBuffer.append(this.fModel.getColumnName(i));
                }
                this.fFileWriter.write(strBuffer.toString());
                this.fFileWriter.flush();
            }
            catch (IOException ex) {
                System.err.println(ex);
            }
        }
    }

    private void loadShowHideProperty() {
        String showproperty = LogoProperties.instance().getProperty("IOStatus.showProperties");
        String[] configure = null;
        if (showproperty == null || showproperty.equals("")) {
            return;
        }
        configure = showproperty.split(",");
        for (int i = 0; i < configure.length; ++i) {
            switch (Integer.valueOf(configure[i])) {
                case 16: {
                    this.fShowAM.setSelected(false);
                    break;
                }
                case 13: {
                    this.fShowAQ.setSelected(false);
                    break;
                }
                case 11: {
                    this.fShowAI.setSelected(false);
                    break;
                }
                case 17: {
                    this.fShowCC.setSelected(false);
                    break;
                }
                case 19: {
                    this.fShowSR.setSelected(false);
                    break;
                }
                case 10: {
                    this.fShowM.setSelected(false);
                    break;
                }
                case 7: {
                    this.fShowQ.setSelected(false);
                    break;
                }
                case 21: {
                    this.fShowFC.setSelected(false);
                    break;
                }
                case 6: {
                    this.fShowI.setSelected(false);
                    break;
                }
                case -1: {
                    this.fShowTimeLine.setSelected(false);
                }
            }
            this.showHideProperty(Integer.valueOf(configure[i]), false);
        }
    }

    private void showHideProperty(int nameID, boolean show) {
        int[] res = this.fDataTransfer.getHardware().getMaxResources();
        int startLine = 0;
        int width = 35;
        switch (nameID) {
            case 16: {
                startLine += res[13];
            }
            case 13: {
                startLine += res[11];
            }
            case 11: {
                startLine += res[17];
            }
            case 17: {
                startLine += res[19];
            }
            case 19: {
                startLine += res[10];
                width = 55;
            }
            case 10: {
                startLine += res[7];
            }
            case 7: {
                startLine += res[21];
            }
            case 21: {
                startLine += res[6];
            }
            case 6: {
                ++startLine;
            }
            case -1: {
                ++startLine;
            }
        }
        if (startLine != 0) {
            int columnCounter = 1;
            if (nameID != -1) {
                columnCounter = res[nameID];
                if (nameID == 17) {
                    width = 35;
                }
            } else {
                width = 80;
            }
            TableColumn column = null;
            for (int i = 0; i < columnCounter; ++i) {
                column = this.fTable.getColumnModel().getColumn(i + startLine);
                column.setMinWidth(show ? width : 0);
                column.setPreferredWidth(show ? width : 0);
            }
            this.fTable.repaint();
        }
    }

    public void storeFieldContents() {
        LogoProperties.instance().setIntProperty("IOStatus.cycleTime", this.fCycleTime.getValue());
        LogoProperties.instance().setIntProperty("IOStatus.recordCount", this.fMaxCount.getValue());
        LogoProperties.instance().setProperty("LogFile", this.fFileName.getText());
        StringBuffer sb = new StringBuffer();
        if (!this.fShowTimeLine.isSelected()) {
            sb.append(-1).append(",");
        }
        if (!this.fShowI.isSelected()) {
            sb.append(6).append(",");
        }
        if (!this.fShowFC.isSelected()) {
            sb.append(21).append(",");
        }
        if (!this.fShowQ.isSelected()) {
            sb.append(7).append(",");
        }
        if (!this.fShowM.isSelected()) {
            sb.append(10).append(",");
        }
        if (!this.fShowCC.isSelected()) {
            sb.append(17).append(",");
        }
        if (!this.fShowAI.isSelected()) {
            sb.append(11).append(",");
        }
        if (!this.fShowAQ.isSelected()) {
            sb.append(13).append(",");
        }
        if (!this.fShowAM.isSelected()) {
            sb.append(16).append(",");
        }
        if (!this.fShowSR.isSelected()) {
            sb.append(19).append(",");
        }
        if (sb.toString().endsWith(",")) {
            LogoProperties.instance().setProperty("IOStatus.showProperties", sb.substring(0, sb.length() - 1));
        } else {
            LogoProperties.instance().setProperty("IOStatus.showProperties", sb.toString());
        }
    }

    public void closeEvent() {
        if (this.fTickerTimer != null) {
            this.fTickerTimer.cancel();
            this.fTickerTimer.purge();
            this.fTickerTimer = null;
        }
        if (this.fDataTransfer != null) {
            this.fDataTransfer.closePort();
            this.fDataTransfer = null;
        }
        this.closeFile();
    }

    private void closeFile() {
        if (this.fFileStream != null) {
            try {
                this.fFileStream.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.fFileStream = null;
        }
        if (this.fFileWriter != null) {
            try {
                this.fFileWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.fFileWriter = null;
        }
    }

    private void writeToLogFile(Object[] values) {
        if (this.fFileWriter != null) {
            try {
                StringBuffer strBuffer = new StringBuffer();
                for (int i = 1; i < this.fModel.getColumnCount(); ++i) {
                    strBuffer.append(values[i]);
                    strBuffer.append(',');
                }
                this.fFileWriter.write(10);
                this.fFileWriter.write(strBuffer.toString());
                this.fFileWriter.flush();
            }
            catch (IOException e) {
                System.err.println(e);
            }
        }
    }

    private String getTimeString(long time) {
        Date newDate = new Date(time);
        DateFormat dataFormat = DateFormat.getTimeInstance(2, Language.getLocale());
        return dataFormat.format(newDate);
    }

    public static void main(String[] args) {
        IOStatusPanel ioStatusPanel = new IOStatusPanel();
        JFrame frame = new JFrame();
        frame.setContentPane(ioStatusPanel);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.setSize(new Dimension(800, 600));
        frame.setVisible(true);
    }

    private class IOStatusTimerTask
    extends TimerTask {
        int preRecordCount;
        long preActionTime;
        final int timeTorrent = 10;

        private IOStatusTimerTask() {
            this.preRecordCount = IOStatusPanel.this.fMaxCount.getValue();
            this.preActionTime = 0L;
            this.timeTorrent = 10;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long now;
            if (this.preRecordCount != IOStatusPanel.this.fMaxCount.getValue()) {
                IOStatusPanel.this.fModel.setRecordCount(IOStatusPanel.this.fMaxCount.getValue());
                this.preRecordCount = IOStatusPanel.this.fMaxCount.getValue();
            }
            if ((now = System.currentTimeMillis()) - this.preActionTime + 10L >= (long)IOStatusPanel.this.fCycleTime.getValue()) {
                try {
                    int[] ioImage = IOStatusPanel.this.fDataTransfer.getRemoteIOStatus();
                    if (ioImage != null) {
                        IOStatusPanel.this.fValueParser.setProcessImage(ioImage);
                        Object[] values = IOStatusPanel.this.fValueParser.getElementValues();
                        IOStatusPanel.this.fModel.addRow(values);
                        IOStatusPanel.this.fTable.repaint();
                        IOStatusPanel.this.fTablePanel.getVerticalScrollBar().setValue(IOStatusPanel.this.fTablePanel.getVerticalScrollBar().getMaximum());
                        IOStatusPanel.this.writeToLogFile(values);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    this.preActionTime = now;
                }
            }
        }
    }

    private class IOStatusProcessImageParser
    extends ProcessImageParser {
        Vector columnNames;

        public IOStatusProcessImageParser(Hardware hardware, Vector names) {
            super(hardware);
            this.columnNames = names;
        }

        public Object[] getElementValues() {
            Object[] values = new Object[this.columnNames.size()];
            values[0] = 0;
            values[1] = IOStatusPanel.this.getTimeString(System.currentTimeMillis());
            for (int i = 2; i < values.length; ++i) {
                int bitNr;
                int blockIndex;
                int byteNr;
                int offsetInImage;
                String columnName = this.columnNames.get(i).toString();
                if (columnName.startsWith("A")) {
                    offsetInImage = this.getOffsetInProcessImage(this.getClassType(columnName));
                    int byteNr2 = (Integer.parseInt(columnName.substring(2)) - 1) * 2 + offsetInImage;
                    values[i] = Util.makeSignedWord(this.fProcessImage[byteNr2 + 1], this.fProcessImage[byteNr2]);
                    continue;
                }
                offsetInImage = this.getOffsetInProcessImage(this.getClassType(columnName));
                values[i] = columnName.startsWith("S") ? Integer.valueOf((this.fProcessImage[byteNr = (blockIndex = Integer.parseInt(columnName.substring(1, 2)) - 1) + offsetInImage] & 1 << (bitNr = Integer.parseInt(columnName.substring(3, 4)) - 1)) > 0 ? 1 : 0) : Integer.valueOf((this.fProcessImage[byteNr = (blockIndex = Integer.parseInt(columnName.substring(1)) - 1) / 8 + offsetInImage] & 1 << (bitNr = blockIndex % 8)) != 0 ? 1 : 0);
            }
            return values;
        }

        private Class getClassType(String name) {
            if (name.startsWith("I")) {
                return InputBlock.class;
            }
            if (name.startsWith("F")) {
                return TDFunctionKeyInputBlock.class;
            }
            if (name.startsWith("Q")) {
                return OutputBlock.class;
            }
            if (name.startsWith("M")) {
                return MarkerBlock.class;
            }
            if (name.startsWith("S")) {
                return ShiftRegisterInputBlock.class;
            }
            if (name.startsWith("C")) {
                return KeyInputBlock.class;
            }
            if (name.startsWith("AI")) {
                return AnalogInputBlock.class;
            }
            if (name.startsWith("AQ")) {
                return AnalogOutputBlock.class;
            }
            if (name.startsWith("AM")) {
                return AnalogMarkerBlock.class;
            }
            return Object.class;
        }

        public void setProcessImage(int[] processImage) {
            super.setProcessImage(processImage);
        }

        public double getAnalogValue(Block block) {
            throw new UnsupportedOperationException();
        }

        public void setBlockResultImage(int[] blockResultImage) {
            throw new UnsupportedOperationException();
        }
    }

    private class IODataModel
    extends DefaultTableModel {
        int maximumRecordCount;

        public IODataModel(Vector rowName) {
            this.columnIdentifiers = rowName;
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public synchronized void setRecordCount(int recordCount) {
            this.maximumRecordCount = recordCount;
            int preSize = this.dataVector.size();
            if (this.maximumRecordCount == preSize) {
                return;
            }
            if (this.maximumRecordCount < preSize) {
                for (int i = 0; i < preSize - this.maximumRecordCount; ++i) {
                    this.removeRow(0);
                }
            }
        }

        public void addRow(Object[] rowData) {
            if (this.dataVector.size() == this.maximumRecordCount) {
                this.removeRow(0);
            }
            super.addRow(rowData);
        }

        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return Language.getString("dialog.IOStatus.ColumnName.Number", "No.");
            }
            if (columnIndex == 1) {
                return Language.getString("dialog.IOStatus.ColumnName.Time", "Time");
            }
            return super.getColumnName(columnIndex);
        }

        public Object getValueAt(int row, int column) {
            if (column == 0) {
                return row + 1;
            }
            return super.getValueAt(row, column);
        }
    }
}

